﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Historia wykształcenia</title>
		<script runat="server">
	
	void OnContextLoad(Object sender, EventArgs args) {
        ArrayList lista = new ArrayList();

        Row[] rows = (Row[])dc[typeof(Row[])];
        foreach (Pracownik pp in rows)
            foreach (HistoriaZatrudnieniaBase hzb in pp.HistoriaZatrudnienia) {
                if (hzb.Typ == TypHistoriiZatrudnienia.Zatrudnienie)
                    continue;
                UkonczonaSzkola usz = (UkonczonaSzkola)hzb;
                if (usz == null)
                    continue;
                lista.Add(usz);
            }

        Grid1.DataSource = lista;
	}

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        UkonczonaSzkola usz = (UkonczonaSzkola)args.Row;
        
        col1.EditValue = usz.Nazwa;
        col2.EditValue = usz.Adres1 + " " + usz.Adres2;
        col3.EditValue = usz.Okres.ToString();
        col4.EditValue = usz.Zawod;
        col5.EditValue = usz.Specjalnosc;
        col6.EditValue = usz.Szkoła;
        col7.EditValue = usz.Staz;        
    }		        

		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="HistoriaWyksztalcenia" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad" Landscape="True"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" title="Historia wykształcenia"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow" GroupLine="{0}" GroupData0="Pracownik">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn ID="col1" Caption="Nazwa"></ea:GridColumn>
					<ea:GridColumn Width="25" ID="col2" Caption="Adres"></ea:GridColumn>
					<ea:GridColumn Width="21" ID="col3" Caption="Okres nauki"></ea:GridColumn>
					<ea:GridColumn Width="20" ID="col4" Caption="Zawód"></ea:GridColumn>
					<ea:GridColumn Width="20" ID="col5" Caption="Specjalność"></ea:GridColumn>
					<ea:GridColumn Width="25" ID="col6" Caption="Staż wg typu ukończonej szkoły"></ea:GridColumn>
					<ea:GridColumn Width="10" ID="col7" Caption="Staż pracy (lata, mies., dni)"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

